definition module windowaccess


//	Clean Object I/O library, version 1.1

/*	Access operations to Window(State)Handle(s).
*/

import devicesystemstate, windowhandle


/*	Dummy values for window handles.
	These are values of which all non-strict values are undef! and dummies for others
*/
dummyWindowHandles		:: WindowHandles      .ps
dummyWindowStateHandle	:: WindowStateHandle  .ps
dummyWindowLSHandle		:: WindowLSHandle .ls .ps
dummyWindowHandle		:: WindowHandle   .ls .ps


/*	Access to the particular WItemInfo alternatives. These functions are partially defined!
*/
getWItemRadioInfo		:: !(WItemInfo .ls .ps) -> RadioInfo	 (.ls,.ps)
getWItemCheckInfo		:: !(WItemInfo .ls .ps) -> CheckInfo	 (.ls,.ps)
getWItemPopUpInfo		:: !(WItemInfo .ls .ps) -> PopUpInfo	 (.ls,.ps)
getWItemSliderInfo		:: !(WItemInfo .ls .ps) -> SliderInfo	 (.ls,.ps)
getWItemTextInfo		:: !(WItemInfo .ls .ps) -> TextInfo
getWItemEditInfo		:: !(WItemInfo .ls .ps) -> EditInfo
getWItemButtonInfo		:: !(WItemInfo .ls .ps) -> ButtonInfo
getWItemCustomButtonInfo:: !(WItemInfo .ls .ps) -> CustomButtonInfo
getWItemCustomInfo		:: !(WItemInfo .ls .ps) -> CustomInfo
getWItemCompoundInfo	:: !(WItemInfo .ls .ps) -> CompoundInfo
getWItemReceiverInfo	:: !(WItemInfo .ls .ps) -> ReceiverHandle .ls .ps


//	Window/dialog identification:
::	WID								// Identify a window/dialog either
	=	ById	!Id					// by its Id, or
	|	ByPtr	!OSWindowPtr		// by its OSWindowPtr

class toWID x :: !x -> WID

instance toWID Id
instance toWID Int

WIDbyId					:: !WID -> Bool				// WIDbyId   (ById  _)  = True; False
WIDbyPtr				:: !WID -> Bool				// WIDbyPtr  (ByPtr _)  = True; False
WIDgetId				:: !WID -> Id				// WIDgetId  (ById  id) = id	(partial function)
WIDgetPtr				:: !WID -> OSWindowPtr		// WIDgetPtr (ByPtr ptr)= ptr	(partial function)
identifyWIDS			:: !WID !WIDS      -> Bool	// identifyWIDS (ById  id)  {wId}  = id ==wId
													// identifyWIDS (ByPtr ptr) {wPtr} = ptr==wPtr
identifyMaybeId			:: !Id !(Maybe Id) -> Bool	// identifyMaybeId id (Just id`) = id==id`
													// identifyMaybeId _ _ = False

/*	Access operations on WindowStateHandles:
	getWindowStateHandleWIDS
		returns the WIDS of the WindowStateHandle argument.
	getWindowStateHandle(WindowMode/WindowKind/WindowTitle/ItemNrs/KeyFocus/WindowInfo/Show/Select/DefaultId/CancelId)
		returns the (WindowMode/WindowKind/Title/item nrs/KeyFocus/Origin/WindowInfo/is shown/is Able/default Id/cancel Id) 
		of the WindowStateHandle argument.
		These functions fail when applied to a placeholder. 
	isWindowStateHandlePlaceHolder
		returns True iff the WindowStateHandle argument is a placeholder.
	identifyWindowStateHandle
		returns True iff the WindowStateHandle argument could be identified by the WID argument.
*/
getWindowStateHandleWIDS		:: !(WindowStateHandle .ps) -> (!WIDS,				!WindowStateHandle .ps)
getWindowStateHandleWindowMode	:: !(WindowStateHandle .ps) -> (!WindowMode,		!WindowStateHandle .ps)
getWindowStateHandleWindowKind	:: !(WindowStateHandle .ps) -> (!WindowKind,		!WindowStateHandle .ps)
getWindowStateHandleWindowTitle	:: !(WindowStateHandle .ps) -> (!Title,				!WindowStateHandle .ps)
getWindowStateHandleItemNrs		:: !(WindowStateHandle .ps) -> (![Int],				!WindowStateHandle .ps)
getWindowStateHandleKeyFocus	:: !(WindowStateHandle .ps) -> (!KeyFocus,			!WindowStateHandle .ps)
getWindowStateHandleWindowInfo	:: !(WindowStateHandle .ps) -> (!Maybe WindowInfo,	!WindowStateHandle .ps)
getWindowStateHandleShow		:: !(WindowStateHandle .ps) -> (!Bool,				!WindowStateHandle .ps)
getWindowStateHandleSelect		:: !(WindowStateHandle .ps) -> (!Bool,				!WindowStateHandle .ps)
getWindowStateHandleDefaultId	:: !(WindowStateHandle .ps) -> (!Maybe Id,			!WindowStateHandle .ps)
getWindowStateHandleCancelId	:: !(WindowStateHandle .ps) -> (!Maybe Id,			!WindowStateHandle .ps)
getWindowStateHandleSize		:: !(WindowStateHandle .ps) -> (!Size,				!WindowStateHandle .ps)
isWindowStateHandlePlaceHolder	:: !(WindowStateHandle .ps) -> (!Bool,				!WindowStateHandle .ps)
identifyWindowStateHandle :: !WID  !(WindowStateHandle .ps) -> (!Bool,				!WindowStateHandle .ps)

setWindowStateHandleWindowTitle	:: !Title				!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleItemNrs		:: ![Int]				!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleKeyFocus	:: !KeyFocus			!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleWindowInfo	:: !(Maybe WindowInfo)	!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleShow		:: !Bool				!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleSelect		:: !Bool				!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleDefaultId	:: !(Maybe Id)			!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleCancelId	:: !(Maybe Id)			!(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleSize		:: !Size				!(WindowStateHandle .ps) -> WindowStateHandle .ps


/*	getWindowHandlesActiveWindow returns the WIDS of the active window/dialogue.
		If the window can not be found, then False and an undefined WIDS are returned.
		If the window can be found, then True and its WIDS are returned.
	hasWindowHandlesWindow searches the indicated window.
		The Boolean result is True iff the window or its placeholder could be found; otherwise it is False.
	getWindowHandlesWindow gets the indicated window.
		If the window can not be found, then False, a dummy WindowStateHandle, and unchanged WindowHandles are returned.
		If the window could be found, then True, the WindowStateHandle, and WindowHandles from which the WindowStateHandle
			is removed are returned. The location of the WindowStateHandle is memorised by means of a place holder.
	removeWindowHandlesWindow removes and gets the indicated window.
		If the window can not be found, then False, a dummy WindowStateHandle, and unchanged WindowHandles are returned.
		If the window could be found, then True, the WindowStateHandle, and WindowHandles from which the WindowStateHandle
			is removed are returned.
	setWindowHandlesWindow sets the indicated window.
		The place holder in the WindowHandles is replaced by the given WindowStateHandle. 
		Exceptions:
			* the argument WindowStateHandle is a place holder
			* the WindowHandles contain a matching non place holder entry
			* the WindowHandles contain no matching place holder entry
		In all of these cases, the function aborts.
	addWindowHandlesWindow adds a new window at the indicated position.
		If index<=0 then the new window is added at the front.
		If index>#windows then the new window is added at the end.
		For all other values the new window is added behind the element at the given index.
*/
getWindowHandlesActiveWindow::									!(WindowHandles .ps) -> (!Bool,WIDS,!WindowHandles .ps)
hasWindowHandlesWindow		:: !WID								!(WindowHandles .ps) -> (!Bool,!WindowHandles .ps)
getWindowHandlesWindow		:: !WID								!(WindowHandles .ps) -> (!Bool,!WindowStateHandle .ps,!WindowHandles .ps)
removeWindowHandlesWindow	:: !WID								!(WindowHandles .ps) -> (!Bool,!WindowStateHandle .ps,!WindowHandles .ps)
setWindowHandlesWindow		::        !(WindowStateHandle .ps)	!(WindowHandles .ps) -> WindowHandles .ps
addWindowHandlesWindow		:: !Index !(WindowStateHandle .ps)	!(WindowHandles .ps) -> WindowHandles .ps


/*	(dis/en)ableWindowSystem toggle the select state of the current windows of an interactive process.
	disableWindowSystem should be used before a modal window is opened,
	enableWindowSystem  should be used after  a modal window has been closed.
*/
disableWindowSystem			::					!(WindowHandles .ps) !*OSToolbox -> (!(!Maybe WIDS,!WindowHandles .ps),!*OSToolbox)
enableWindowSystem			:: !(Maybe WIDS)	!(WindowHandles .ps) !*OSToolbox -> (              !WindowHandles .ps, !*OSToolbox)


/*	From DeviceSystemState retrieve the WindowHandles if present.
	The argument DeviceSystemState must be a WindowSystemState, otherwise the function aborts.
*/
WindowSystemStateGetWindowHandles	:: !(DeviceSystemState .ps)	-> WindowHandles .ps
